<?php
// Thiết lập header để trình duyệt hiểu đây là JSON
header('Content-Type: application/json');

// --- Cấu hình ---
// URL của API Node.js server của bạn
// Thay đổi 'chinhanh09.ddns.net' và '3000' bằng thông tin thực của bạn
$nodeJsApiUrl = "http://localhost:3000/send-message2";

// Phương thức HTTP phải là POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode([
        'success' => false,
        'message' => 'Chỉ chấp nhận phương thức POST.'
    ]);
    exit();
}

// Đọc dữ liệu JSON từ body của request PHP
$input = json_decode(file_get_contents('php://input'), true);

// Lấy groupid và textToSend từ dữ liệu đầu vào
$groupId = $input['groupid'] ?? null;
$textToSend = $input['textToSend'] ?? null;
$urgency = $input['urgency'] ?? 'Default'; // Default value is "Default"

// Kiểm tra dữ liệu đầu vào
if (empty($groupId) || empty($textToSend)) {
    http_response_code(400); // Bad Request
    echo json_encode([
        'success' => false,
        'message' => 'Thiếu groupid hoặc textToSend trong body của yêu cầu.'
    ]);
    exit();
}

// --- Gửi yêu cầu POST đến Node.js Zalo API ---
$payload = json_encode([
    'groupid' => $groupId,
    'textToSend' => $textToSend,
	'urgency' => 'Urgency.'.$urgency
]);

// Cấu hình context cho cURL hoặc file_get_contents
$options = [
    'http' => [
        'header'  => "Content-Type: application/json\r\n",
        'method'  => 'POST',
        'content' => $payload,
        'ignore_errors' => true // Rất quan trọng để bắt lỗi HTTP status code
    ]
];
$context  = stream_context_create($options);

// Thực hiện yêu cầu đến Node.js API
$response = @file_get_contents($nodeJsApiUrl, false, $context); // Dùng @ để ẩn warning nếu lỗi kết nối

// Xử lý phản hồi từ Node.js API
if ($response === FALSE) {
    // Lỗi kết nối hoặc không nhận được phản hồi từ Node.js server
    http_response_code(500); // Internal Server Error
    echo json_encode([
        'success' => false,
        'message' => 'Không thể kết nối hoặc nhận phản hồi từ Zalo API server (Node.js).',
        'error_details' => error_get_last() // Cung cấp thêm chi tiết lỗi PHP
    ]);
    exit();
}

$http_status = explode(' ', $http_response_header[0])[1]; // Lấy mã trạng thái HTTP
$nodeJsResponse = json_decode($response, true);

if ($http_status >= 200 && $http_status < 300) { // Thành công (2xx status code)
    http_response_code(200);
    echo json_encode([
        'success' => true,
        'message' => 'Tin nhắn Zalo đã được gửi thành công qua Node.js API.',
        'node_js_response' => $nodeJsResponse // Bao gồm phản hồi từ Node.js
    ]);
} else { // Lỗi từ Node.js API
    http_response_code($http_status); // Truyền lại mã lỗi từ Node.js API
    echo json_encode([
        'success' => false,
        'message' => 'Có lỗi xảy ra từ Zalo API server (Node.js).',
        'node_js_response' => $nodeJsResponse, // Bao gồm phản hồi lỗi từ Node.js
        'http_status_code' => $http_status
    ]);
}

?>