<?php
/**
 * sendfile.php
 * Input:  threadId, invoice_code (POST/GET)
 * Flow:   SmartSign -> base64 -> LƯU FILE (uploads) -> Node /send-attachment (đường dẫn con)
 * Output: JSON (kết quả từ Node)
 */

header('Content-Type: application/json; charset=utf-8');

/* ============ CẤU HÌNH ============ */
const NODE_ENDPOINT      = 'localhost:3000/send-attachment';   // Node local
                               // 'Group' | 'User'
const SMARTSIGN_API      = 'https://tracuuhd.smartsign.com.vn/Pages/Ajax/AjaxDownloadFile.aspx/GetPDF?Code=';
const UPLOAD_DIR         = 'C:/laragon/www/uploads'; // PHẢI TRÙNG với SHARED_DIR của Node

/* ============ INPUT ============ */
 $DEFAULT_THREAD_TYPE= $_POST['type']     ?? $_GET['type']     ?? '';   
$threadId     = $_POST['threadId']     ?? $_GET['threadId']     ?? '';
$invoice_code = $_POST['invoice_code'] ?? $_GET['invoice_code'] ?? '';
$Content_to_Send = $_POST['text'] ?? $_GET['text'] ?? '';
$invoice_num	=$_POST['invoice_number'] ?? $_GET['invoice_number'] ?? '';
if (!$threadId || !$invoice_code) {
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>'Thiếu threadId hoặc invoice_code']);
  exit;
}

/* ============ HÀM ============ */
function http_post_json(string $url, array $payload, int $timeout = 60) {
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
    CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
    CURLOPT_TIMEOUT        => $timeout,
  ]);
  $resp = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $err  = curl_error($ch);
  curl_close($ch);
  return [$code, $resp, $err];
}

function smartsign_get_pdf_base64(string $invoice_code, int $timeout = 60) {
  $url = SMARTSIGN_API . rawurlencode($invoice_code);
  $ch = curl_init($url);
  curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST           => true,
    CURLOPT_HTTPHEADER     => ['Content-Type: application/json; charset=utf-8'],
    CURLOPT_POSTFIELDS     => '', // body rỗng như AutoIt
    CURLOPT_TIMEOUT        => $timeout,
  ]);
  $resp = curl_exec($ch);
  $code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  $err  = curl_error($ch);
  curl_close($ch);

  if ($resp === false || $code < 200 || $code >= 300) {
    throw new RuntimeException('SmartSign lỗi: ' . ($err ?: "HTTP $code"));
  }

  $json = json_decode($resp, true);
  if (isset($json['d']) && is_string($json['d']) && $json['d'] !== '') {
    return $json['d'];
  }
  if (preg_match('/"d":"(.*?)"/', $resp, $m)) return $m[1];

  throw new RuntimeException('Không tìm thấy base64 trong phản hồi SmartSign.');
}

/* ============ XỬ LÝ ============ */
try {
  // 1) Lấy base64 PDF từ SmartSign
  $b64 = smartsign_get_pdf_base64($invoice_code);
  $b64 = preg_replace('#^data:application/pdf;base64,#i', '', trim($b64));

  // 2) Lưu file vào UPLOAD_DIR (dùng chung với Node)
  if (!is_dir(UPLOAD_DIR)) {
    @mkdir(UPLOAD_DIR, 0775, true);
  }
  $safeName = "$invoice_num.pdf";
  $absPath  = rtrim(UPLOAD_DIR, '\\/') . DIRECTORY_SEPARATOR . $safeName;

  $bin = base64_decode($b64, true);
  if ($bin === false) {
    throw new RuntimeException('Giải mã base64 thất bại.');
  }
  if (file_put_contents($absPath, $bin) === false) {
    throw new RuntimeException('Lưu file PDF lỗi: ' . $absPath);
  }

  // 3) Gọi Node: gửi theo "đường dẫn con" (ví dụ "COM25M...DG.pdf")
  // Node sẽ resolve: SHARED_DIR + '/' + attachments[i]
  $payload = [
    'threadId'    => $threadId,
    'type'        => $DEFAULT_THREAD_TYPE,
    'caption'     => $Content_to_Send,
    'attachments' => [$safeName] // chỉ tên file
  ];

  [$nodeCode, $nodeResp, $nodeErr] = http_post_json(NODE_ENDPOINT, $payload, 60);

  if ($nodeResp === false || $nodeCode < 200 || $nodeCode >= 300) {
    http_response_code(502);
    echo json_encode([
      'success' => false,
      'message' => 'Forward Node thất bại',
      'error'   => $nodeErr ?: "HTTP $nodeCode",
      'saved'   => $absPath,
      'respone'   => $nodeCode
    ], JSON_UNESCAPED_UNICODE);
    exit;
  }

  // 4) Trả kết quả Node
  http_response_code($nodeCode);
  echo $nodeResp;

} catch (Throwable $e) {
  http_response_code(500);
  echo json_encode([
    'success' => false,
    'message' => 'Lỗi xử lý sendfile',
    'error'   => $e->getMessage()
  ], JSON_UNESCAPED_UNICODE);
}
