<?php
/**
 * undofriendrequest.php
 * Input (POST/GET/JSON):
 *   - userId (tùy chọn nếu có phoneNumber)
 *   - phoneNumber (tùy chọn nếu có userId)
 * Hành vi:
 *   - Forward sang Node.js /undo-friend-request
 *   - Trả về nguyên JSON & HTTP code từ Node
 */
header('Content-Type: application/json; charset=utf-8');

const NODE_ENDPOINT = 'http://localhost:3000/undo-friend-request';

// Gom input: ưu tiên JSON body, sau đó đến GET/POST
$raw = file_get_contents('php://input');
$in  = [];
if ($raw) {
  $json = json_decode($raw, true);
  if (is_array($json)) $in = $json;
}
$in = array_merge($_GET, $_POST, $in);

// Lấy tham số
$userId      = isset($in['userId']) ? trim((string)$in['userId']) : '';
$phoneNumber = isset($in['phoneNumber']) ? trim((string)$in['phoneNumber']) : '';

// Validate
if ($userId === '' && $phoneNumber === '') {
  http_response_code(400);
  echo json_encode(['success'=>false,'message'=>'Thiếu userId hoặc phoneNumber.'], JSON_UNESCAPED_UNICODE);
  exit;
}

// Payload chuyển sang Node
$payload = [
  'userId'      => $userId !== '' ? $userId : null,
  'phoneNumber' => $phoneNumber !== '' ? $phoneNumber : null
];

// Gọi Node
$ch = curl_init(NODE_ENDPOINT);
curl_setopt_array($ch, [
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_POST           => true,
  CURLOPT_HTTPHEADER     => ['Content-Type: application/json'],
  CURLOPT_POSTFIELDS     => json_encode($payload, JSON_UNESCAPED_UNICODE),
  CURLOPT_TIMEOUT        => 30
]);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$error    = curl_error($ch);
curl_close($ch);

// Trả về kết quả
if ($response === false || $httpCode < 200 || $httpCode >= 300) {
  http_response_code($httpCode ?: 502);
  echo json_encode([
    'success' => false,
    'message' => 'Gọi Node /undo-friend-request thất bại.',
    'error'   => $error ?: "HTTP $httpCode",
    'request' => $payload
  ], JSON_UNESCAPED_UNICODE);
  exit;
}

http_response_code($httpCode);
echo $response;
