<?php
header('Content-Type: application/json');

// URL Node.js
$nodeUrl = "http://localhost:3000/add-user";

// Chỉ cho POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Chỉ chấp nhận POST.']);
    exit;
}

// Lấy phoneNumber từ form/data hoặc JSON
$raw = file_get_contents('php://input');
$payload = json_decode($raw, true);
$phoneNumber = $payload['phoneNumber'] ?? ($_POST['phoneNumber'] ?? '');
$msg = $payload['msg'] ?? ($_POST['msg'] ?? '');
if (!$phoneNumber || !is_string($phoneNumber)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Thiếu phoneNumber (string).']);
    exit;
}

// Forward sang Node
$ch = curl_init($nodeUrl);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_HTTPHEADER => ['Content-Type: application/json'],
    CURLOPT_POSTFIELDS => json_encode(['phoneNumber' => $phoneNumber, 'msg' => $msg]),
    CURLOPT_TIMEOUT => 30
]);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
$err = curl_error($ch);
curl_close($ch);

if ($err) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'PHP cURL error', 'error' => $err]);
    exit;
}

// Truyền nguyên trạng mã và nội dung từ Node về client
http_response_code($httpCode);
echo $response;
